/*
 * morph.c
 * Tommaso Polonelli
 *
 * Copyright (C) 2016 ETH Zurich, University of Bologna
 * Copyright (C) 2018 Tommaso Polonelli
 *
 * This software may be modified and distributed under the terms
 * of the MIT license.  See the LICENSE file for details.
 *
 * Created on: May 28, 2020
 *
 */

#ifndef MORPH_H_
#define MORPH_H_

/* PMSIS includes */
#include "pmsis.h"
#include "bsp/ram.h"
#include "bsp/ram/hyperram.h"

/*********** Structures *************/

typedef struct m_kernel {
	int Rows;
	int Cols;
	int rowOrigin;
	int colOrigin;
	uint8_t *kernel;
}m_kernel_t;

typedef enum e_kernel {
	K_STAR_3,
	K_CIRCLE_3,
	K_SQUARE_3
}e_kernel_e;


m_kernel_t ConfigDefaultKernel(e_kernel_e e);
void ClearDefaultKernel(m_kernel_t * K);
void Erosion(uint8_t *img, uint8_t *dst, int Rows, int Cols, struct pi_device *dma_device, m_kernel_t K);
void Dilation(uint8_t *img, uint8_t *dst, int Rows, int Cols, struct pi_device *dma_device, m_kernel_t K);
void Opening( uint8_t *img, int Rows, int Cols, struct pi_device *dma_device, m_kernel_t K );
void Closing( uint8_t *img, int Rows, int Cols, struct pi_device *dma_device, m_kernel_t K );
int Img_Ones_Count (uint8_t *img, int size);

void Kernel_Col_Erosion(uint8_t *in,
		uint8_t *img,
		uint8_t *dst,
		int start_Cols,
		int end_Cols,
		int Cols,
		m_kernel_t * K);

void Kernel_Col_Dilation(uint8_t *in,
		uint8_t *img,
		uint8_t *dst,
		int start_Cols,
		int end_Cols,
		int Cols,
		m_kernel_t * K);


#endif /* MORPH_H_ */
